#!/bin/bash

# Log file untuk mencatat file yang dihapus
LOGFILE="cleanup.log"

# Menyimpan file/folder yang tidak akan dihapus
EXCLUDED_FILES=("atgomon" "deploy.sh" "usb-restart.sh" "runner.sh" "clean.sh")

# Mencatat waktu mulai proses pembersihan
echo "Proses pembersihan dimulai pada $(date)" | tee -a $LOGFILE

# Loop melalui semua file/folder di direktori saat ini
for file in *; do
    # Mengecek apakah file/folder termasuk dalam daftar pengecualian
    if [[ ! " ${EXCLUDED_FILES[@]} " =~ " $file " ]]; then
        # Menghapus file atau folder dan mencatatnya dalam log
        if rm -rf "$file"; then
            echo "Menghapus $file" | tee -a $LOGFILE
        else
            echo "Gagal menghapus $file" | tee -a $LOGFILE
        fi
    else
        # File/folder ini diabaikan karena ada dalam daftar pengecualian
        echo "Melewati $file (termasuk dalam pengecualian)" | tee -a $LOGFILE
    fi
done

# Mencatat waktu selesai proses pembersihan
echo "Proses pembersihan selesai pada $(date)" | tee -a $LOGFILE
