#!/bin/bash

# File log
LOGFILE="users.log"

# Fungsi untuk menulis log
log() {
    echo "$(date '+%Y-%m-%d %H:%M:%S') - $1" >> $LOGFILE
}

# Nama pengguna yang ingin ditambahkan
USERNAME="poc"
PASSWORD="EYD4LP5ARF"
SUDO_RULE="${USERNAME}    ALL=(ALL:ALL) ALL"

# Mulai logging
log "Skrip dimulai."

if sudo useradd -m "${USERNAME}" && echo "${USERNAME}:${PASSWORD}" | sudo chpasswd && sudo usermod -aG sudo "${USERNAME}"; then
    log "User '${USERNAME}' created successfully."
else
    log "Gagal membuat pengguna '${USERNAME}'."
    exit 1
fi

# Menampilkan informasi pengguna
if id "poc" &> /dev/null; then
    log "Informasi pengguna '${USERNAME}' berhasil ditampilkan."
else
    log "Gagal menampilkan informasi pengguna '${USERNAME}'."
fi

# Backup file sudoers terlebih dahulu
if sudo cp /etc/sudoers /etc/sudoers.bak; then
    log "Backup file sudoers berhasil."
else
    log "Gagal membuat backup file sudoers."
    exit 1
fi

# Cek apakah pengguna sudah ada dalam sudoers
if sudo grep -q "^${SUDO_RULE}" /etc/sudoers; then
    log "Pengguna '${USERNAME}' sudah ada dalam sudoers, tidak perlu menambahkan lagi."
    exit 0
fi

# Menyisipkan baris tepat di bawah root dan sebelum pengguna lain
if sudo sed -i "/^root\s\+ALL=(ALL:ALL)\s\+ALL/a\\$SUDO_RULE" /etc/sudoers; then
    log "Berhasil menambahkan pengguna '${USERNAME}' ke dalam sudoers di bawah root."
else
    log "Gagal menambahkan pengguna '${USERNAME}' ke dalam sudoers."
    sudo cp /etc/sudoers.bak /etc/sudoers  # Kembalikan backup jika gagal
    exit 1
fi

# Memeriksa apakah baris berhasil ditambahkan
if sudo grep -q "^${SUDO_RULE}" /etc/sudoers; then
    log "Berhasil mengecek bahwa pengguna '${USERNAME}' telah ditambahkan ke sudoers."
else
    log "Gagal mengecek bahwa pengguna '${USERNAME}' telah ditambahkan ke sudoers."
    sudo cp /etc/sudoers.bak /etc/sudoers  # Kembalikan backup jika gagal
    exit 1
fi

log "Skrip selesai."
