#!/bin/bash

echo "--- Only Execute Inside Folder Downloaded!"
echo "--- Run using sudo sh deploy.sh"
echo ""
echo ""

if [ `id -u` -ne 0 ]; then
  echo "Please run this script as root or using sudo!"
  exit
fi

# Variables for the first service
SERVICE_NAME="atgomon"
SERVICE_DESCRIPTION="atgomon application service"
USERNAME="atgomon"
GROUPNYA="atgomon"
WORKING_DIRECTORY="/opt/atgomon"
EXECUTABLE_PATH="$WORKING_DIRECTORY/$SERVICE_NAME"

# Variables for the second service
SERVICE_NAME_2="updater_bin"
SERVICE_DESCRIPTION_2="updater_bin application service"
EXECUTABLE_PATH_2="$WORKING_DIRECTORY/$SERVICE_NAME_2"

HOSTNYA=$(hostname)

echo "Hostname: $HOSTNYA"

# Uninstall Existing
echo "Stopping Services..."
sudo systemctl stop "$SERVICE_NAME"
sudo systemctl stop "$SERVICE_NAME_2"

# Remove old Binaries
sudo mkdir -p $WORKING_DIRECTORY
rm -rf $EXECUTABLE_PATH
rm -rf $EXECUTABLE_PATH_2

echo ""
echo ""
echo "Copying/Moving binaries to Production"
sudo mv atgomon $EXECUTABLE_PATH
sudo mv updater_bin $EXECUTABLE_PATH_2

sudo systemctl enable "$SERVICE_NAME"
sudo systemctl start "$SERVICE_NAME"

sudo systemctl enable "$SERVICE_NAME_2"
sudo systemctl start "$SERVICE_NAME_2"
