#!/bin/bash

# Create the override directory if it doesn't exist
if [ ! -d /etc/systemd/system/getty@tty1.service.d/ ]; then
    echo "Creating override directory for getty@tty1..."
    sudo mkdir -p /etc/systemd/system/getty@tty1.service.d/
fi

# Create or update the override file
echo "Creating or updating override file..."
{
    echo "[Service]"
    echo "ExecStart="
    echo "ExecStart=-/sbin/agetty --noclear %I \$TERM"
} | sudo tee /etc/systemd/system/getty@tty1.service.d/override.conf

# Reload systemd and restart the service
echo "Reloading systemd and restarting getty@tty1..."
sudo systemctl daemon-reload
sudo systemctl restart getty@tty1

# Suggest to check LightDM or GDM configurations
echo "Please check for any LightDM or GDM configurations that may enable auto-login."
echo "You may need to check /etc/lightdm/lightdm.conf or /etc/gdm3/custom.conf."
echo "Done! Please reboot your system to verify the changes."
