#!/bin/bash

echo "--- Hanya butuh sekali eksekusi diawal saja ---"
echo "--- Run using sudo ./network-setup.sh"
echo ""

if [ "$(id -u)" -ne 0 ]; then
  echo "Please run this script as root or using sudo!"
  exit 1
fi

ETH_NAME="eth0"
IP_ADDRESS="192.168.22.254/24"
GATEWAY="192.168.22.1"
DNS="8.8.8.8 1.1.1.1"

IP_RAW_SET=""

echo "Select deployment type:"
echo "1) Production"
echo "2) Office Test DHCP"
echo "3) Custom IP"
read -p "Enter choice [1-3]: " choice

case $choice in
  1)
    echo "Deploying to Production..."
    IP_RAW_SET="[Match]
Name=$ETH_NAME

[Network]
Address=$IP_ADDRESS
Gateway=$GATEWAY
DNS=$DNS"
    ;;
  2)
    echo "Deploying to Development..."
    IP_RAW_SET="[Match]
Name=$ETH_NAME

[Network]
DHCP=yes"
    ;;
  3)
    echo "Custom IP..."
    read -p "Enter Ethernet Name: " ETH_NAME
    read -p "Enter IP Address: " IP_ADDRESS
    read -p "Enter Gateway: " GATEWAY
    read -p "Enter DNS: " DNS
    IP_RAW_SET="[Match]
Name=$ETH_NAME

[Network]
Address=$IP_ADDRESS
Gateway=$GATEWAY
DNS=$DNS"
    ;;
  *)
    echo "Invalid choice!"
    exit 1
    ;;
esac

# Ensure systemd-networkd is installed and active before removing NetworkManager
echo "Installing and enabling systemd-networkd..."
sudo systemctl unmask systemd-networkd || { echo "Failed to unmask systemd-networkd"; exit 1; }
sudo systemctl enable systemd-networkd || { echo "Failed to enable systemd-networkd"; exit 1; }
sudo systemctl start systemd-networkd || { echo "Failed to start systemd-networkd"; exit 1; }

# Stop and remove NetworkManager only after systemd-networkd is working
echo "Stopping and disabling NetworkManager..."
sudo systemctl stop NetworkManager || { echo "Failed to stop NetworkManager"; exit 1; }
sudo systemctl disable NetworkManager || { echo "Failed to disable NetworkManager"; exit 1; }
sudo apt remove -y network-manager || { echo "Failed to remove NetworkManager"; exit 1; }
sudo apt autoremove -y || { echo "Failed to autoremove dependencies"; exit 1; }

# Create systemd-networkd config directory if it doesn't exist
sudo mkdir -p /etc/systemd/network

echo "Setting IP..."
echo "$IP_RAW_SET" | sudo tee "/etc/systemd/network/10-$ETH_NAME.network" > /dev/null || { echo "Failed to write network configuration"; exit 1; }

# Restart systemd-networkd
echo "Restarting systemd-networkd..."
sudo systemctl restart systemd-networkd || { echo "Failed to restart systemd-networkd"; exit 1; }

# Flush old IP and set new IP address
echo "Configuring IP address..."
sudo ip addr flush dev $ETH_NAME || { echo "Failed to flush IP address"; exit 1; }
sudo ip addr add $IP_ADDRESS dev $ETH_NAME || { echo "Failed to set IP address"; exit 1; }
sudo ip route add default via $GATEWAY || { echo "Failed to set default gateway"; exit 1; }

echo "Network setup completed without reboot!"
echo "IP Address:"
ip addr show $ETH_NAME

echo "Select Next Action:"
echo "1) Exit"
read -p "Enter choice [1]: " choice
case $choice in
  1)
    echo "Exited..."
    exit 0
    ;;
  *)
    echo "Invalid choice! Exited..."
    exit 1
    ;;
esac
